---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-Security HTTP

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **LoginThrottlingListenerのレート制限の詳細動作**：リスナー内部のRateLimiter連携詳細は未確認
  2. **パフォーマンス要件の具体的数値**：定量的パフォーマンス基準は根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Security/Http/Firewall.php` - Firewallクラスの実装
- E-02: `src/Symfony/Component/Security/Http/FirewallMap.php` - FirewallMapクラスの実装
- E-03: `src/Symfony/Component/Security/Http/AccessMap.php` - AccessMapクラスの実装
- E-04: `src/Symfony/Component/Security/Http/HttpUtils.php` - HttpUtilsクラスの実装
- E-05: `src/Symfony/Component/Security/Http/SecurityEvents.php` - セキュリティイベント定義
- E-06: `src/Symfony/Component/Security/Http/Authenticator/AuthenticatorInterface.php` - 認証器インターフェース
- E-07: `src/Symfony/Component/Security/Http/EventListener/` - イベントリスナーディレクトリ
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FirewallはEventSubscriberInterfaceを実装し、KernelEvents::REQUESTを優先度8で監視する | E-01 (99-104行目) | ○ |
| C-02 | FirewallMapはRequestMatcherに基づき最初に一致するファイアウォール設定を返す | E-02 (41-50行目) | ○ |
| C-03 | getListenersの戻り値は認証リスナー配列、ExceptionListener、LogoutListenerの3要素 | E-01 (55-57行目), E-02 (29行目) | ○ |
| C-04 | ExceptionListenerはイベントディスパッチャーに登録・解除される | E-01 (59-62行目, 89-97行目) | ○ |
| C-05 | LogoutListenerは優先度に基づき適切な位置に挿入される | E-01 (65-84行目) | ○ |
| C-06 | callListenersで各リスナーのsupports/authenticateを順次実行する | E-01 (107-120行目) | ○ |
| C-07 | AccessMapはURLパターンごとにロール配列とチャネルを返す | E-03 (31-45行目) | ○ |
| C-08 | HttpUtilsはdomainRegexpによるオープンリダイレクト防止機能を持つ | E-04 (49-59行目) | ○ |
| C-09 | HttpUtilsのcreateRequestはセッションとセキュリティ属性を引き継ぐ | E-04 (88-108行目) | ○ |
| C-10 | AuthenticatorInterfaceは5つのメソッド（supports, authenticate, createToken, onAuthenticationSuccess, onAuthenticationFailure）を定義 | E-06 (36-86行目) | ○ |
| C-11 | SecurityEventsはINTERACTIVE_LOGINとSWITCH_USERの2イベントを定義 | E-05 (28, 36行目) | ○ |
| C-12 | 画面No.27セキュリティパネルが補助機能として関連 | E-08 (74行目) | ○ |
| C-13 | フォームログイン、JSON認証、HTTP Basic等の認証方式をサポート | E-07 (ディレクトリ内ファイル一覧) | ○ |
| C-14 | CheckCredentialsListener、CsrfProtectionListener等のイベントリスナーが存在 | E-07 (ディレクトリ内ファイル一覧) | ○ |
| C-15 | HttpUtils::checkRequestPathでルート名またはパスでマッチング可能 | E-04 (120-143行目) | ○ |
| C-16 | メインリクエストのみを処理対象とする | E-01 (48-50行目) | ○ |
| C-17 | LoginThrottlingListenerによるブルートフォース攻撃対策 | **根拠なし** | △ |
| C-18 | パフォーマンス要件（マッチャー数を最小限に） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- LoginThrottlingListenerの内部実装の詳細（RateLimiterとの連携方法）
  - 候補：`src/Symfony/Component/Security/Http/EventListener/LoginThrottlingListener.php` / RateLimiterコンポーネントのドキュメント
- パフォーマンス要件の具体的な数値基準
  - 候補：Symfony公式ドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 認証フローの基本的な説明 - コードと整合している
- 0: ファイアウォールマップの動作説明 - コードと整合している
- 1: LoginThrottlingの詳細動作 - リスナーの内部実装を追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Firewall.phpの処理フローが正確に記載されているか
- [ ] AuthenticatorInterfaceの5メソッドの説明が正確か
- [ ] HttpUtilsのドメイン検証ロジックの説明が正確か
- [ ] 関連画面マッピング（画面No.27）が正しいか
- [ ] LoginThrottlingListenerの動作詳細を補完する必要があるか確認
